/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.commands.citizencommands;

import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.entity.citizen.AbstractEntityCitizen;
import com.minecolonies.coremod.commands.commandTypes.IMCColonyOfficerCommand;
import com.minecolonies.coremod.commands.commandTypes.IMCCommand;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.Optional;
import net.minecraft.command.CommandSource;
import net.minecraft.command.arguments.ILocationArgument;
import net.minecraft.command.arguments.Vec3Argument;
import net.minecraft.entity.Entity;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;

public class CommandCitizenTeleport
implements IMCColonyOfficerCommand {
    @Override
    public int onExecute(CommandContext<CommandSource> context) {
        Entity sender = ((CommandSource)context.getSource()).func_197022_f();
        int colonyID = IntegerArgumentType.getInteger(context, (String)"colonyID");
        IColony colony = IColonyManager.getInstance().getColonyByDimension(colonyID, (RegistryKey<World>)(sender == null ? World.field_234918_g_ : ((CommandSource)context.getSource()).func_197023_e().func_234923_W_()));
        if (colony == null) {
            ((CommandSource)context.getSource()).func_197030_a((ITextComponent)new TranslationTextComponent("com.minecolonies.command.colonyidnotfound", new Object[]{colonyID}), true);
            return 0;
        }
        ICitizenData citizenData = colony.getCitizenManager().getCivilian(IntegerArgumentType.getInteger(context, (String)"citizenID"));
        if (citizenData == null) {
            ((CommandSource)context.getSource()).func_197030_a((ITextComponent)new TranslationTextComponent("com.minecolonies.command.citizeninfo.notfound"), true);
            return 0;
        }
        Optional<AbstractEntityCitizen> optionalEntityCitizen = citizenData.getEntity();
        if (!optionalEntityCitizen.isPresent()) {
            ((CommandSource)context.getSource()).func_197030_a((ITextComponent)new TranslationTextComponent("com.minecolonies.command.citizeninfo.notloaded"), true);
            return 0;
        }
        AbstractEntityCitizen entityCitizen = optionalEntityCitizen.get();
        ILocationArgument targetLocation = Vec3Argument.func_200385_b(context, (String)"location");
        BlockPos targetPos = targetLocation.func_197280_c((CommandSource)context.getSource());
        if (((CommandSource)context.getSource()).func_197023_e() == entityCitizen.field_70170_p) {
            entityCitizen.func_70012_b(targetPos.func_177958_n(), targetPos.func_177956_o(), targetPos.func_177952_p(), entityCitizen.func_195046_g(1.0f), entityCitizen.func_195050_f(1.0f));
            entityCitizen.getNavigation().func_75499_g();
        }
        return 1;
    }

    @Override
    public String getName() {
        return "teleport";
    }

    @Override
    public LiteralArgumentBuilder<CommandSource> build() {
        return (LiteralArgumentBuilder)IMCCommand.newLiteral(this.getName()).then(IMCCommand.newArgument("colonyID", IntegerArgumentType.integer((int)1)).then(IMCCommand.newArgument("citizenID", IntegerArgumentType.integer((int)1)).then(IMCCommand.newArgument("location", Vec3Argument.func_197301_a()).executes(this::checkPreConditionAndExecute))));
    }
}

